//	CCopyTree.h

#ifndef _H_CCopyTree
#define	_H_CCopyTree

#ifndef __GNUC__
	#include <Files.h>
#endif

#include "GenStructs.h"

typedef enum {
	CCT_Copy_NONE, 
	
	CCT_Copy_ENTRY, 
	CCT_Copy_FSSPEC, 
	CCT_Copy_TREE,
	CCT_Copy_META_TREE,
	
	CCT_Copy_NUMTYPES
} CCT_CopyType;

#if 0
struct FileInfo {
  OSType              fileType;               /* The type of the file */
  OSType              fileCreator;            /* The file's creator */
  UInt16              finderFlags;            /* ex: kHasBundle, kIsInvisible... */
  Point               location;               /* File's location in the folder */
                                              /* If set to {0, 0}, the Finder will place the item automatically */
  UInt16              reservedField;          /* (set to 0) */
};

struct ExtendedFileInfo {
  SInt16              reserved1[4];           /* Reserved (set to 0) */
  UInt16              extendedFinderFlags;    /* Extended flags (custom badge, routing info...) */
  SInt16              reserved2;              /* Reserved (set to 0). Comment ID if high-bit is clear */
  SInt32              putAwayFolderID;        /* Put away folder ID */
};
#endif

typedef struct {
	Boolean				hasFInfo;
	FInfo				fileInfo;
	
	Boolean				hasXFInfo;
	FXInfo				xFileInfo;
} CCT_ForkInfo;

typedef struct {
	char				nameAC[256];
	Byte				fileType;		//	using ProDOS file types
	ushort				auxType;		//	or load addr
	DateTimeRec			creDate;
	DateTimeRec			modDate;
	Gen_AccessBits		access;
	Handle				dataH;			//	data fork

	//	only for forked files
	Boolean				forkedB;
	Handle				resH;		//	resource fork
	CCT_ForkInfo		forkInfo;
} CCT_MemFileRec, **CCT_MemFileRecH;

class	CCopyTree;
class	CCopyFile;
class	CDialogCopy;

typedef struct {
	CDialogCopy		*copyDialogP0;
	CCopyFile		*destP;
	ushort			totalItemsS;
	ulong			totalSizeL;
} CCT_CopyRec;

#include "Utils.h"
#include "CEntry.h"

OSErr	GetNewCopyTree(
	CCT_CopyType	copyType, 
	Ptr				myData, 
	CCopyTree		**copyTreeH);

Boolean			IsCopyTranslated(void);
void			SetCopyTranslated(Boolean isCopyTranslatedB);

/*****************************/
class	CCopyTree {
	
	public:	OSErr	ICopyTree(CCT_CopyType destCopyType, Ptr destFolderP);
	
	void			Dispose(void);

	OSErr			AddEntry(
		CCopyFile		*parentP0,
		CCT_CopyType	copyType, 
		Ptr				myData, 
		CCopyFile		**newEntryH0);

	OSErr			Remove(CCopyFile *copyFileP);

	OSErr			ScanSourceForCopy(Ptr myDataP, CCopyFile **fileExistsH);

	OSErr			Copy(Boolean showProgressB);

	OSErr			GetNewCopyFile(
		CCopyFile		*parent0, 
		CCT_CopyType	copyType, 
		Ptr				myData, 
		CCopyFile		**copyFileH);
		
	/*****************************/
	CCopyFile		*i_destP;
	CCopyFile		*i_sourceP;
};

#endif